% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalDeletionAA.R
\name{globalDeletionAA}
\alias{globalDeletionAA}
\title{globalDeletionAA}
\usage{
globalDeletionAA(aa)
}
\arguments{
\item{aa}{\code{AAStringSet} [mandatory]}
}
\value{
\code{AAStringSet}
}
\description{
This function returns an \code{AAStringSet} reduced by all
sites containing any gaps ("-", "+", ".") or missing ("X") sites.
}
\examples{
## define two cds sequences
cds1 <- Biostrings::DNAString("ATGCAACATTGC")
cds2 <- Biostrings::DNAString("ATG---CATTGC")
cds1.cds2.aln <- c(Biostrings::DNAStringSet(cds1),
    Biostrings::DNAStringSet(cds2))
#globalDeletionAA(cds2aa(cds1.cds2.aln))
cds1.cds2.aln |> cds2aa() |> globalDeletionAA()
}
\author{
Kristian K Ullrich
}
