% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnastring2dist.R
\name{dnastring2dist}
\alias{dnastring2dist}
\title{dnastring2dist}
\usage{
dnastring2dist(
  dna,
  model = "IUPAC",
  threads = 1,
  symmetric = TRUE,
  score = NULL,
  mask = NULL,
  region = NULL,
  ...
)
}
\arguments{
\item{dna}{\code{DNAStringSet} [mandatory]}

\item{model}{specify model either "IUPAC" or any model from
\code{ape::dist.dna} [default: IUPAC]}

\item{threads}{number of parallel threads [default: 1]}

\item{symmetric}{symmetric score matrix [default: TRUE]}

\item{score}{\code{score matrix} use score matrix to calculate
distances [default: NULL]}

\item{mask}{\code{IRanges} object indicating masked sites
[default: NULL]}

\item{region}{\code{IRanges} object indicating region to use for dist
calculation. Default is null, meaning all sites are used [default: NULL]}

\item{...}{other \code{ape::dist.dna} parameters
(see \code{\link[ape]{dist.dna}})}
}
\value{
A data.frame of pairwise distance values \code{distSTRING} and
sites used \code{sitesUsed}
}
\description{
This function calculates pairwise distances for all
combinations of a \code{DNAStringSet}.
}
\examples{
## load example sequence data
data("hiv", package="MSA2dist")
#dnastring2dist(hiv, model="IUPAC")
hiv |> dnastring2dist(model="IUPAC")
#dnastring2dist(hiv, model="K80")
hiv |> dnastring2dist(model="K80")
data("woodmouse", package="ape")
#dnastring2dist(dnabin2dnastring(woodmouse), score=iupacMatrix())
woodmouse |> dnabin2dnastring() |> dnastring2dist()
#dnastring2dist(hiv, model = "IUPAC", threads = 2)
hiv |> dnastring2dist(model = "IUPAC", threads = 2)
## create mask
mask1 <- IRanges::IRanges(start=c(1,61,121), end=c(30,90,150))
## use mask
hiv |> dnastring2dist(model="IUPAC", mask=mask1)
## use region
region1 <- IRanges::IRanges(start=c(1,139), end=c(75,225))
hiv |> dnastring2dist(model="IUPAC", region=region1)
## use mask and region
hiv |> dnastring2dist(model="IUPAC", mask=mask1, region=region1)
## use asymmetric score matrix
myscore <- iupacMatrix()
myscore[1, 4] <- 0.5
(hiv |> dnastring2dist(score=myscore, symmetric=FALSE))$distSTRING[1:2, 1:2]
}
\seealso{
\code{\link[ape]{dist.dna}}
}
\author{
Kristian K Ullrich
}
