#' @title iupac-data
#' @name iupac-data
#' @description Example IUPAC sequences created with \code{angsd}
#' from different house mouse (Mus musculus) sub-populations
#' from Harr et al. (2016) \code{DNAStringSet}.
#' @importFrom Biostrings DNAStringSet
#' @references Harr et al. (2016) Genomic resources for wild populations of the
#' house mouse, Mus musculus and its close relative
#' Mus spretus. \emph{Scientific data.} \bold{3(1)}, 1-14.
#' @docType data
#' @usage data(iupac)
#' @format an object of class \code{DNAStringSet}
#' see \code{\link[Biostrings]{XStringSet-class}}
#' @keywords datasets
#' @examples
#' data("iupac", package="MSA2dist")

"iupac"
