% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libraryDepth.R
\name{estimateDepthFactors}
\alias{estimateDepthFactors}
\title{estimate library size correction factors}
\usage{
estimateDepthFactors(
  obj,
  lib.factor = NULL,
  which.lib = "both",
  depth.estimator = "uq"
)
}
\arguments{
\item{obj}{the MpraObject}

\item{lib.factor}{the factor associating each sample to a library. Can be a
factor or the name of a column in the object's colAnnot. If not provided, the
data is assumed to have been generated from a single library, and constant
library depth is set.}

\item{which.lib}{which library to compute the depth factors for. Options are
"both" (default), "dna" or "rna". If the DNA and RNA counts have different 
library factors, this function should be called twice: once with "dna" and
once with "rna"}

\item{depth.estimator}{a character indicating which depth estimation to use,
or a function to perform the estimation. Currently supported values are "uq" 
for upper quantile of non-zero values (default), "rle" for RLE (uses 
geometric mean, and is therefore not recommended if libraries have 0 counts),
 or "totsum" for total sum.
For a function input: function should take a numeric vector and return a 
single numeric, and preferably handle NA values. See examples.}
}
\value{
the MpraObject with estimated values for sequencing depth factors
}
\description{
estimate library size correction factors
}
\note{
since in most MPRA experiments multiple barcodes exist within a single
library, each column in the matrix is usually not a separate library. For
this reason, it is recommended to supply this function with the appropriate
partitioning of the data matrix columns into libraries, see lib.factor
}
\examples{
data <- simulateMPRA(tr = rep(2,10), da=NULL, nbatch=2, nbc=20)
obj <- MpraObject(dnaCounts = data$obs.dna, 
                  rnaCounts = data$obs.rna, 
                  colAnnot = data$annot)
obj <- estimateDepthFactors(obj, lib.factor = "batch", which.lib = "both")
## Upper quantile, using a higher quantile than 0.75:
obj <- estimateDepthFactors(obj, lib.factor = "batch", which.lib = "both",
                            depth.estimator = function(x) quantile(x, .95, 
                                 na.rm=TRUE))
}
