% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_coexpression.R
\name{shuffle_group_matrix}
\alias{shuffle_group_matrix}
\title{shuffle_group_matrix, Reorder cell type-specific expression matrix during 
co-expression simulation. Copied from ACORDE (https://github.com/ConesaLab/acorde)
to facilitate stability and running within our scripts
This function is a slightly modified copy of the `shuffle_group_matrix` function
from the `Acorde` package (v1.0.0), originally developed by Arzalluz-Luque A, 
Salguero P, Tarazona S, Conesa A. (2022). acorde unravels functionally 
interpretable networks of isoform co-usage from single cell data. Nature communications
1828. DOI: 10.1038/s41467-022-29497-w. The original package is licensed under the 
GPL-3 license.}
\usage{
shuffle_group_matrix(sim_data, feature_ids, group_pattern, ngroups)
}
\arguments{
\item{sim_data}{A count matrix with features as rows and cells as columns.
Feature IDs must be included in an additional column named \code{feature}.}

\item{feature_ids}{A two-column \code{tibble} containing \code{top} and \code{bottom}
columns, each including the feature IDs of features to be used as highly or
lowly expressed when shuffling by the indicated expression pattern.}

\item{group_pattern}{A logical vector, containing \code{TRUE} to indicate that
high expression in that cell type is desired and \code{FALSE} if the opposite.
The vector must be ordered as the cell types in \code{sim_data}.}

\item{ngroups}{An integer indicating the number of groups that top and bottom
features should be divided into. It is computed by dividing the number
of features selected as highly/lowly expressed by the size of the clusters
that are to be generated.}
}
\value{
An expression matrix, with the same characteristics as \code{sim_data},
and a number of features defined as the total amount of top/bottom features
selected divided by the number of clusters for which co-expression patterns
where supplied.
}
\description{
This function is used internally by \code{acorde} to perform
the shuffling of simulated features for an individual cell type, as part of
the co-expression simulation process. The function is called recursively by
\code{\link[MOSim:simulate_coexpression]{simulate_coexpression()}} to
perform the simulation on a full scRNA-seq matrix.
}
