% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc_MOSim.R
\name{sc_param_estimation}
\alias{sc_param_estimation}
\title{sc_param_estimation}
\usage{
sc_param_estimation(
  omics,
  cellTypes,
  diffGenes = list(c(0.2, 0.2)),
  minFC = 0.25,
  maxFC = 4,
  numberCells = NULL,
  mean = NULL,
  sd = NULL,
  noiseGroup = 0.5,
  group = 1,
  genereggroup
)
}
\arguments{
\item{omics}{named list containing the omics to simulate as names, which can 
be "scRNA-seq" or "scATAC-seq".}

\item{cellTypes}{list where the i-th element of the list contains the column 
indices for i-th cell type. List must be a named list.}

\item{diffGenes}{If number groups > 1, Percentage DE genes to simulate.
List of vectors (one per group to compare to group 1) where the vector
contains absolute number of genes for Up and Down ex: c(250, 500) or a 
percentage for up, down ex: c(0.2, 0.2). The rest will be NE}

\item{minFC}{Threshold of FC below which are downregulated, by default 0.25}

\item{maxFC}{Threshold of FC above which are upregulated, by default 4}

\item{numberCells}{vector of numbers. The numbers correspond to the number 
of cells the user wants to simulate per each cell type. The length of the 
   vector must be the same as length of \code{cellTypes}.}

\item{mean}{vector of numbers of mean depth per each cell type. Must be specified 
just if \code{numberCells} is specified.}

\item{sd}{vector of numbers of standard deviation per each cell type. Must be 
specified just if \code{numberCells} is specified.}

\item{noiseGroup}{OPTIONAL. Number indicating the desired standard deviation
between treatment groups}

\item{group}{Group for which to estimate parameters}

\item{genereggroup}{List with information of genes, clusters and regulators
that must be related to each other}
}
\value{
a list of Seurat object, one per each omic.

a named list with simulation parameters for each omics as values.
}
\description{
Evaluate the users parameters for single cell simulation and use SPARSim
to simulate the main dataset. Internal function
}
\examples{
omicsList <- sc_omicData(list("scRNA-seq"))
cell_types <- list('Treg' = c(1:10),'cDC' = c(11:20),'CD4_TEM' = c(21:30),
'Memory_B' = c(31:40))
#estimated_params <- sc_param_estimation(omicsList, cell_types)

}
