% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlottingMO.R
\name{plotModuleKM}
\alias{plotModuleKM}
\title{Plot Kaplan-Meier survival curves of a specific module}
\usage{
plotModuleKM(
  MOM,
  moduleNumber,
  formula = "Surv(days, status) ~ PC1",
  fileName = NULL,
  paletteNames = NULL,
  h = 9,
  w = 7,
  risk.table = TRUE,
  pval = TRUE,
  size = 1,
  inYears = FALSE,
  discr_prop_pca = 0.15,
  discr_prop_events = 0.05,
  additional_discrete = NULL,
  additional_continuous = NULL,
  ...
)
}
\arguments{
\item{MOM}{a \code{MultiOmicsModule} class object}

\item{moduleNumber}{numeric value. The module number of interest}

\item{formula}{a formula for the survival analysis. It should be written as
'Surv(days, status) ~ omic'. To plot more than one omic, write them
separated by a '+' character after the separator (~)}

\item{fileName}{optional filenames to save the plot}

\item{paletteNames}{a palette name to be used}

\item{h}{the height of the plot}

\item{w}{the width of the plot}

\item{risk.table}{logical value. If TRUE, shows the \code{risk.table}. Default
is TRUE.}

\item{pval}{logical value. If TRUE, shows the p-value of the curves. Default
is TRUE.}

\item{size}{line width of the KM curves}

\item{inYears}{set time in years}

\item{discr_prop_pca}{the minimal proportion to compute the PCA classes}

\item{discr_prop_events}{the minimal proportion to compute the event classes}

\item{additional_discrete}{names of the additional discrete variables to
include}

\item{additional_continuous}{names of the additional continous variables to
include}

\item{...}{additional arguments passed to \code{guessInvolvement} and \code{get}
function}
}
\value{
a ggsurvplot class object
}
\description{
Given a \code{MultiOmicsModule} class object and a specific module number, it
plots Kaplan-Meier curves, in which the strata corresponds to the omics
}
\examples{
data(multiOmics)
data(reactSmall)

genesToUse <- row.names(multiOmics[[1]])

MOM_survival <- multiOmicsSurvivalModuleTest(multiOmics, reactSmall[[1]],
    survFormula = "Surv(days, status) ~", autoCompleteFormula = TRUE,
    useTheseGenes = genesToUse
)

plotModuleKM(MOM_survival, 1,
    formula = "Surv(days, status) ~ mut + expPC2",
    paletteNames = "Paired", inYears = TRUE
)

}
