% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlottingMO.R
\name{plotModuleInGraph}
\alias{plotModuleInGraph}
\title{Plot a Directed Graph of the MultiOmicsModules Object}
\usage{
plotModuleInGraph(
  modulesobj,
  pathList,
  moduleNumber,
  orgDbi = "org.Hs.eg.db",
  paletteNames = NULL,
  legendLabels = NULL,
  fileName = NULL,
  discr_prop_pca = 0.15,
  discr_prop_events = 0.05,
  pathTitle = NULL,
  ...
)
}
\arguments{
\item{modulesobj}{a \code{MultiOmicsModule} class object}

\item{pathList}{a \code{PathwayList} from \code{graphite} package that contains the
pathways to be used}

\item{moduleNumber}{a module number}

\item{orgDbi}{if needed, indicates an organism Dbi to translate the vectors}

\item{paletteNames}{named vector of MOSpalettes, names replace makeLegend
arguments}

\item{legendLabels}{set up your favourite names for the omics}

\item{fileName}{optional filenames to save the plot}

\item{discr_prop_pca}{the minimal proportion to compute the PCA classes}

\item{discr_prop_events}{the minimal proportion to compute the event classes}

\item{pathTitle}{title of the graph, to be searched in \code{pathList}}

\item{...}{additional arguments passed to \code{guessInvolvement} function}
}
\value{
a MOSClip plot in form of a list class object
}
\description{
From a \code{MultiOmicsModules} object, it plots the position of a given module
in the pathway. The omics are also represented in the graph.
}
\examples{
data(multiOmics)
data(reactSmall)

genesToUse <- row.names(multiOmics[[1]])

MOM_survival <- multiOmicsSurvivalModuleTest(multiOmics, reactSmall[[1]],
    survFormula = "Surv(days, status) ~", autoCompleteFormula = TRUE,
    useTheseGenes = genesToUse
)

plotModuleInGraph(MOM_survival, reactSmall,
    moduleNumber = 1,
    paletteNames = c(exp = "red", met = "green", 
                     mut = "blue", cnv = "yellow")
)

}
