% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic.saturation.r
\name{sampleOverlap}
\alias{sampleOverlap}
\title{The core function to compute which sample-specific alterations overlap with 
genomic events that are explained 
via DIGGIT.}
\usage{
sampleOverlap(
  MomaObject,
  viper.samples,
  selected.tfs,
  interaction.map,
  cnv.threshold = 0.5,
  mutation.filter = NULL,
  idx.range = NULL,
  verbose = FALSE
)
}
\arguments{
\item{MomaObject}{Object reference of momaRunner class}

\item{viper.samples}{Sample vector to restrict sample-specific analysis to}

\item{selected.tfs}{Transcription factors being analyzed}

\item{interaction.map}{List object of events 'covered' by the supplied 
interactions of type mut/amp/del/fus}

\item{cnv.threshold}{Numeric absolute value to threshold SNP6 and/or GISTIC 
or other CNV scores. Above that absolute value is considered a positive event.}

\item{mutation.filter}{A vector of whitelisted mutation events, in entrez gene IDs}

\item{idx.range}{Number of tfs to check for genomic saturation calculation, 
default is 1253}

\item{verbose}{Output status during the run (default=FALSE)}
}
\value{
A list of lists, indexed by sample name, with coverage 
statistics/data for each sample
}
\description{
The core function to compute which sample-specific alterations overlap with 
genomic events that are explained 
via DIGGIT.
}
\keyword{internal}
