% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDISTS4Peak.R
\name{plotDISTS4Peak}
\alias{plotDISTS4Peak}
\title{plotDISTS4Peak}
\usage{
plotDISTS4Peak(MD, Peak.id, dist.method = "MMD", whichContrast = 1,
  Zoom = TRUE, xlim = NULL, ylim = NULL, xlog10 = TRUE, title = NULL)
}
\arguments{
\item{MD}{DBAmmd Object. This Object can be created using \code{DBAmmd()}.}

\item{Peak.id}{Peak id to specify which Peak to plot.
(coresponding to names of Regions(MD))}

\item{dist.method}{specify method used for distances
between samples. Currently only Maximum Mean Discrepancy (MMD)
and Kolmogorov-Smirnov (KS) implemented.
(DEFAULT: 'MMD')}

\item{whichContrast}{index determining which of the set contrast should be used.
(DEFAULT: 1)}

\item{Zoom}{(DEFAULT: TRUE)}

\item{xlim}{specify x range (DEFAULT: NULL)}

\item{ylim}{specify y range (DEFAULT: NULL)}

\item{xlog10}{should x range be plotted in log10 scale (DEFAULT: TRUE)}

\item{title}{(DEFAULT: NULL)}
}
\description{
showing all distances for one region
}
\examples{
dev.off()
load(system.file("data/MMD.RData", package="MMDiff2"))
plotDISTS4Peak(MMD,Peak.id = '6',dist.method='MMD', whichContrast=1)

}

