% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{update}
\alias{update}
\alias{update.MLSeq}
\alias{update,MLSeq-method}
\title{Update \code{MLSeq} objects returnd from \code{classify()}}
\usage{
\method{update}{MLSeq}(object, ..., env = .GlobalEnv)

\S4method{update}{MLSeq}(object, ..., env = .GlobalEnv)
}
\arguments{
\item{object}{a model of \code{MLSeq} class returned by \code{\link{classify}}}

\item{...}{optional arguements passed to \code{\link{classify}} function.}

\item{env}{an environment. Define the environment where the trained model is stored.}
}
\value{
same object as an MLSeq object returned from \code{classify}.
}
\description{
This function updates the MLSeq object. If one of the options is changed inside MLSeq object, it should be updated
to pass its effecs into classification results.
}
\note{
When an \code{MLSeq} object is updated, new results are updated on the given object. The results before update process are
lost when update is done. To keep the results before update, one should copy the MLSeq object to a new object in global environment.
}
\examples{
\dontrun{
library(DESeq2)
data(cervical)

# a subset of cervical data with first 150 features.
data <- cervical[c(1:150), ]

# defining sample classes.
class <- data.frame(condition = factor(rep(c("N","T"), c(29, 29))))

n <- ncol(data)  # number of samples
p <- nrow(data)  # number of features

# number of samples for test set (30\% test, 70\% train).
nTest <- ceiling(n*0.3)
ind <- sample(n, nTest, FALSE)

# train set
data.train <- data[ ,-ind]
data.train <- as.matrix(data.train + 1)
classtr <- data.frame(condition = class[-ind, ])

# train set in S4 class
data.trainS4 <- DESeqDataSetFromMatrix(countData = data.train,
                   colData = classtr, formula(~ 1))

# test set
data.test <- data[ ,ind]
data.test <- as.matrix(data.test + 1)
classts <- data.frame(condition=class[ind, ])

data.testS4 <- DESeqDataSetFromMatrix(countData = data.test,
                                      colData = classts, formula(~ 1))

## Number of repeats (repeats) might change model accuracies ##
# Classification and Regression Tree (CART) Classification
cart <- classify(data = data.trainS4, method = "rpart",
          ref = "T", preProcessing = "deseq-vst",
          control = trainControl(method = "repeatedcv", number = 5,
                                 repeats = 3, classProbs = TRUE))
cart

# Change classification model into "Random Forests" (rf)
method(cart) <- "rf"
rf <- update(cart)

rf
}

}
\seealso{
\code{\link{classify}}
}
