% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_classes.R
\docType{class}
\name{MLSeq-class}
\alias{MLSeq-class}
\title{\code{MLSeq} object}
\description{
For classification, this is the main class for the \code{MLSeq} package. It contains all the information including trained model,
selected genes, cross-validation results, etc.
}
\details{
Objects can be created by calls of the form \code{new("MLSeq", ...)}. This type
of objects is created as a result of \code{classify} function of \code{MLSeq} package.
It is then used in \code{\link{predict}} or \code{\link{predictClassify}} function for predicting the class labels of new samples.
}
\note{
An \code{MLSeq} class stores the results of \code{classify} function and offers further slots that are populated
during the analysis. The slot \code{inputObject} stores the raw and transformed data throughout the classification. The slot
\code{modelInfo} stores all the information about classification model. These results may contain the classification table
and performance measures such as accuracy rate, sensitivity, specifity, positive and negative predictive values, etc. It also
contains information on classification method, normalization and transformation used in the classification model.
Lastly, the slot \code{metaData} stores the information about modified or updated slots in MLSeq object.
}
\section{Slots}{


\describe{
  \item{\code{inputObject}:}{stores the data in \code{\link[DESeq2]{DESeqDataSet}} object.}
  \item{\code{modelInfo}:}{stores all the information about classification model. The object is from subclass \code{MLSeqModelInfo}. See \code{\link{MLSeqModelInfo-class}} for details.}
  \item{\code{metaData}:}{metadata for MLSeq object. The object is from subclass \code{MLSeqMetaData}. See \code{\link{MLSeqMetaData-class}} for details.}
}
}

\seealso{
\code{\link{MLSeqModelInfo-class}}, \code{\link{MLSeqMetaData-class}}
}
\author{
Dincer Goksuluk, Gokmen Zararsiz, Selcuk Korkmaz, Vahap Eldem, Ahmet Ozturk and Ahmet Ergun Karaagaoglu
}
