% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{listPathways}
\alias{listPathways}
\title{List all the available biological pathways in KEGG, Reactome and
WikiPathways}
\usage{
listPathways(organism, database)
}
\arguments{
\item{organism}{The name of the organism under consideration. The different
databases have different supported organisms. To see the list of supported
organisms for a given database, use the \code{\link[=supportedOrganisms]{supportedOrganisms()}} function}

\item{database}{The name of the database to use. It must be one of: \code{KEGG},
\code{Reactome}, and \code{WikiPathways}}
}
\value{
A \code{character} vector containing the pathway names present in the
specified database.
}
\description{
This function can be used to retrieve a list of valid biological pathways
present in KEGG, Reactome and WikiPathways.
}
\note{
This function uses the \code{graphite} package to retrieve biological pathways
from KEGG, Reactome and WikiPathways.
}
\examples{
# list the mouse pathways present in WikiPathways
listPathways("Mus musculus", "WikiPathways")

}
\references{
Sales, G., Calura, E., Cavalieri, D. et al. graphite - a Bioconductor
package to convert pathway topology to gene network.
BMC Bioinformatics 13, 20 (2012),
\url{https://doi.org/10.1186/1471-2105-13-20}.
}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
