% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{mirnaTargets}
\alias{mirnaTargets}
\title{Explore miRNA-target pairs}
\usage{
mirnaTargets(object)
}
\arguments{
\item{object}{A \code{\link[=MirnaExperiment-class]{MirnaExperiment}} object containing
miRNA and gene data}
}
\value{
A \code{data.frame} object containing the interactions between miRNAs and target
genes, as retrieved with the \code{\link[=getTargets]{getTargets()}} function.
}
\description{
This function accesses the \code{targets} slot of a
\code{\link[=MirnaExperiment-class]{MirnaExperiment}}
object. After retrieving miRNA targets with the \code{\link[=getTargets]{getTargets()}} function,
the interactions between miRNAs and target genes are stored in the
\code{targets} slot and can be explored with this function.
}
\examples{
# load example MirnaExperiment object
obj <- loadExamples()

# visualize targets
targets_df <- mirnaTargets(obj)

}
\author{
Jacopo Ronchi, \email{jacopo.ronchi@unimib.it}
}
