% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotMIRAProfiles}
\alias{plotMIRAProfiles}
\title{Plot summary methylation profile}
\usage{
plotMIRAProfiles(binnedRegDT, featID = unique(binnedRegDT[, featureID]),
  plotType = "line", colBlindOption = FALSE,
  sampleTypeColName = "sampleType")
}
\arguments{
\item{binnedRegDT}{A datatable with specific column names containing:
bin numbers(binnedRegionDT column), 
aggregated methylation values (methylProp column), 
name of the region set (featureID column), 
case/control column (sampleType column), 
sample name (sampleName column).}

\item{featID}{Region set names in a single string or vector of strings.}

\item{plotType}{Line or jitter (ggplot2).}

\item{colBlindOption}{If TRUE, function will plot with a color blind
friendly palette which could be helpful when plotting multiple colors.}

\item{sampleTypeColName}{character object. The name of the column that
contains sample type or condition information (eg case vs control).
Line color will be assigned based on this if it is present and there are
more than two unique sample types.}
}
\value{
A plot of class "gg"/ "ggplot" that shows MIRA profiles
}
\description{
Plot one or multiple methylation profiles. Displays each region set
in a different subplot.
If you only want to plot certain region sets,
subset with the `featID` parameter.
}
\examples{
data("exampleBins", package = "MIRA")
MIRAplot <- plotMIRAProfiles(binnedRegDT = exampleBins)

}
