% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deconv.R
\name{deconv}
\alias{deconv}
\title{Estimation of cellular composition in high-throughput data from
heterogeneous tissues}
\usage{
deconv(
  se,
  source = "cross",
  method = c("nnls", "JNMF", "TCA"),
  use_refactor = c(1000, NULL),
  Step = c(10^(-8), 10^(-6)),
  Eps = 10^(-4),
  Iter = 500,
  cell_counts = NULL,
  pinit = "nnls",
  ref_pnl = NULL
)
}
\arguments{
\item{se}{A `SummarizedExperiment` object with bulk protein expression
data frame contained in assay,
a bulk transcript expression data frame (`gene_data`) contained in
`metadata` slot (can be rescaled using either log or MinMax transformations,
but need to be consistent between two bulk data). A "signature matrix" 
functions as a reference containing known cellular signatures 
(either `ref_protein` or `ref_gene` as an element in the `metadata` slot) 
may be necessary for certain `source`and `method` options. 
To ensure the reliability of the results obtained, we strongly recommend 
that the "signature matrix" should exclusively comprise markers that have 
been previously validated in the literature.}

\item{source}{A character string denotes which molecular profiles to be
deconvoluted. The setting of `proteins`or `transcript` means single-source
deconvolution with source-specific signature matrix, while `cross` means
proteome deconvolution based on transcriptome-proteome with matched samples.}

\item{method}{A character string specifies the deconvolution method to be 
employed. In the current version, only 'nnls' is supported for single-source 
deconvolution. Besides the bulk data, `ref_protein` or `ref_gene` is 
required for protein or gene deconvolution, respectively. 
For cross-source deconvolution, `JNMF` or `TCA` are valid options. 
If `JNMF`, an external reference containing cell counts 
in a similar tissue type (typically obtainable from small-scale single-cell 
or flow cytometry experiments) is necessary if `pinit = "rdirichlet"`; 
A "signature matrix" is required for other methods.
If `TCA`, an input of pre-estimated transcriptome 
proportions, denoted as `prop_gene` as an element in the `metadata` slot, 
is required. This input can be derived from single-source deconvolution 
using `nnls` included in this package, or from an external source.}

\item{use_refactor}{A numeric value indicate the number of proteins included
for proportion estimates based on refactor values. Note that `ajive_decomp`
with `refactor_loading = TRUE` required if this method applied. 
If NULL, then all proteins included in assay will be used.}

\item{Step}{A numeric vector indicates the step size in projected gradient 
descent for cell count fraction parameter and cell size parameter, 
respectively. Only valid if `method = JNMF`.}

\item{Eps}{A numeric value indicates the convergence criteria for projected 
gradient descent. Only valid if `method = JNMF`.}

\item{Iter}{A numeric value indicates the maximum iteration time for 
projected gradient descent. Only valid if `method = JNMF`.}

\item{cell_counts}{A matrix containing cell counts across multiple subjects, 
where subjects are represented as rows and cell types as columns. Each entry 
(i, j) in the matrix indicates the count of cells belonging to the ith 
subject and jth cell type. Only required if `method = JNMF` and 
`pinit = "rdirichlet"`.}

\item{pinit}{Accepts either a numeric matrix or a character indicating the 
method for initializing initial values for cellular fraction. If `pinit` is a
numeric matrix (pre-estimated transcriptome proportions using other methods), 
each row represents the cellular fraction for each sample 
across various cell types. The resulting cellular fraction will match the 
cell types defined in `pinit`. Alternatively, `pinit` can be generated using 
either the `rdirichlet` or `nnls` method.}

\item{ref_pnl}{A "signature matrix" functions as a reference containing 
known cellular signatures. It is optional. If provided, the initial values 
for purified data will be generated based on `ref_pnl`. Otherwise, 
the initial values for purified data will be generated using a normal 
distribution based on bulk data. Please note that the input signature matrix 
should have the same rescaling transformation as the bulk 
transcriptomes/proteomic.}
}
\value{
A `SummarizedExperiment`. The cell-type proportion estimates for each
sample are stored as elements starting with prop in the metadata slot. 
If `method = JNMF`, then the cellular fractions obtained from proteomics and 
transcriptomics are stored in the `prop` and `prop2` elements, respectively, 
within the metadata slot. The purified data is stored in a list with the 
same length as the number of subjects (the number of columns in the assay). 
For subject i, the purified protein expression data can be obtained by 
accessing `se_sim@metadata$purified[[i]][["X1"]]`, and similarly, 
 the purified transcript expression data can be obtained by accessing 
`se_sim@metadata$purified[[i]][["X2"]`].
}
\description{
This function returns a `SummarizedExperiment` object including cell-type
proportion estimates for each sample.
}
\details{
This is a function developed to implement cell-type proportion deconvolution
using either single or cross sources.
}
\examples{
data(se)
se <- deconv(se, source = "protein", method = "nnls", use_refactor = NULL)

}
