% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/getMetadata.R
\name{getMetadata}
\alias{getMetadata}
\alias{getMetadata,MgnifyClient-method}
\title{Get all study, sample and analysis metadata for the supplied analysis
accessions}
\usage{
getMetadata(x, ...)

\S4method{getMetadata}{MgnifyClient}(x, accession, ...)
}
\arguments{
\item{x}{A \code{MgnifyClient} object.}

\item{...}{Optional arguments; not currently used.}

\item{accession}{A single character value or a vector of analysis accession
IDs specifying accessions to retrieve data for.}
}
\value{
A \code{data.frame} containing metadata for each analysis in the
\code{accession} list. Each row represents a single analysis.
}
\description{
Get all study, sample and analysis metadata for the supplied analysis
accessions
}
\details{
The function retrieves all study, sample and analysis metadata associated
with provided analysis accessions.
}
\examples{
# Create a client object
mg <- MgnifyClient(useCache = FALSE)

# Download all associated study/sample and analysis metadata
accession_list <- c("MGYA00377505")
meta_dataframe <- getMetadata(mg, accession_list)

}
