% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runDiffMeanAnalysis.R
\name{runDiffMeanAnalysis}
\alias{runDiffMeanAnalysis}
\title{Run differential mean analysis}
\usage{
runDiffMeanAnalysis(
  set,
  model,
  weights = NULL,
  method = "ls",
  max_iterations = 100,
  betas = TRUE,
  resultSet = TRUE,
  warnings = TRUE
)
}
\arguments{
\item{set}{Matrix, \code{GenomicRatioSet}, \code{SummarizedExperiment} or 
\code{ExpressionSet}.}

\item{model}{Model matrix or formula to get model matrix from \code{set}.}

\item{weights}{weights used in the lmFit model.}

\item{method}{String indicating the method used in the regression: "ls" or 
"robust". (Default: "ls")}

\item{max_iterations}{Numeric indicating the maximum number of iterations
done in the robust method.}

\item{betas}{If \code{set} is a \code{GenomicRatioSet}, should beta values be
used? (Default: TRUE)}

\item{resultSet}{Should results be encapsulated in a \code{resultSet}? (Default: TRUE)}

\item{warnings}{Should warnings be displayed? (Default:TRUE)}
}
\value{
\code{MArrayLM} or \code{resultSet} with the result of the differential
mean analysis.
}
\description{
Run differential mean analysis using t-moderated statistics. This function relies
on \code{lmFit} from limma package.
}
\examples{
if (require(minfiData)){
 mvalues <- getM(MsetEx)[1:100, ]
 model <- model.matrix(~ Sample_Group, data = pData(MsetEx)) 
 res <- runDiffMeanAnalysis(mvalues, model, method = "ls")
 res
}
}
