% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRegion.R
\name{plotRegion}
\alias{plotRegion}
\title{Plot results in a genomic region}
\usage{
plotRegion(
  rset,
  range,
  results = names(rset),
  genome = "hg19",
  rset2,
  tPV = 5,
  fNames = c("chromosome", "start", "end"),
  fNames2 = c("chromosome", "start", "end")
)
}
\arguments{
\item{rset}{\code{ResultSet}}

\item{range}{\code{GenomicRanges} with the region coordinates}

\item{results}{Character with the analyses that will be included in the plot.
By default, all analyses available are included.}

\item{genome}{String with the genome used to retrieve transcripts annotation:
hg19, hg38, mm10. (Default: "hg19")}

\item{rset2}{Additional \code{ResultSet}}

\item{tPV}{Threshold for P-Value}

\item{fNames}{Names from rset fData}

\item{fNames2}{Names from rset2 fData}
}
\value{
Regional plot
}
\description{
Plot the results from the different analyses of a \code{ResultSet} in a specific
genomic region. It can plot all the results from \code{runPipeline}.
}
\details{
This plot allows to have a quick summary of the methylation or gene
expression analyses in a given region. If we use a \code{ResultSet} obtained 
from methylation data, transcripts annotation is obtained from archive. If we
use a \code{ResultSet} obtained from gene expression data, transcripts annotation
is taken from fData. 

This plot can be used to plot the results of one dataset (methylation or gene
expression) or to represent the association between methylation and gene 
expression data. If only one dataset is used, the p-values and the coefficients 
of DiffMean and DiffVar analyses are plotted. If we pass two \code{ResultSet}s, 
\code{rset} should contain methylation results and a \code{rset2} the gene expression 
results.
}
