% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFeature.R
\name{plotFeature}
\alias{plotFeature}
\title{Plot values of a feature}
\usage{
plotFeature(set, feat, variables = colnames(pheno)[1], betas = TRUE)
}
\arguments{
\item{set}{\code{ExpressionSet}, \code{GenomicRatioSet} or \code{SummarizedExperiment.}}

\item{feat}{Numeric with the index of the feature or character with its name.}

\item{variables}{Character vector with the names of the variables to be used 
in the splitting. Two variables is the maximum allowed.}

\item{betas}{If \code{set} is a \code{GenomicRatioSet}, should beta values be
used? (Default: TRUE)}
}
\value{
A plot is generated on the current graphics device.
}
\description{
Plot values of a feature splitted by one or two variables.
}
\examples{
if (require(minfiData)){
set <- ratioConvert(mapToGenome(MsetEx[1:10,]))
 plotFeature(set, 1, variables = "Sample_Group")
 }
}
