% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbqnSimuData.R
\name{mbqnSimuData}
\alias{mbqnSimuData}
\title{Generate a random/structured data matrix}
\usage{
mbqnSimuData(model = "rand", nrow = NULL, ncol = NULL, show.fig = FALSE)
}
\arguments{
\item{model}{character indicating one of the three different type of models:
\code{"rand"}(default) a Gaussian random matrix of size nrow x ncol
(default 1000 x 10), \code{"omics"} a Gaussian random matrix of
size 1264 x 18 that mimics intensity profiles and missing values as
present in real data, and \code{"omics.dep"} is the same as \code{"omics"}
but with an additional single, differentially expressed RI feature.}

\item{nrow}{number of rows of data matrix (only for \code{model = "rand"}).}

\item{ncol}{number of columns of data matrix
(only for \code{model = "rand"}).}

\item{show.fig}{logical inidicating whether data properties are plot to
figure (only for \code{model = "omics"} and \code{model = "omics.dep"}).}
}
\value{
\code{matrix} of size nrow x ncol.
}
\description{
Generate a random data matrix with or without proteomics,
log-transformed feature intensity-like properties.
}
\details{
For model \code{"rand"}, each matrix element is drawn from a
standard normal distribution \eqn{N(0,1)}. For model \code{"omics"}, the
matrix elements of each row are drawn from a Gaussian distribution
\eqn{N(\mu_i,\sigma_i^2)} where the mean and standard deviation itself are
drawn Gaussian distributions, i.e. \eqn{\sigma_i~N(0,0.0625)} and
\eqn{\mu_i~N(28,4)}. About 35\\% of the matrix values are set to NA according
to the missing value pattern present in real protein LFQ
intensities. For model \code{"omics.dep"}, a single differentially epxressed
RI feature is stacked on top of the matrix from model \code{"omics"}.
}
\examples{
mbqnSimuData(model = "rand")
mbqnSimuData(model = "rand", 2000,6)
set.seed(1234)
mbqnSimuData(model = "omics")
set.seed(1111)
mbqnSimuData(model = "omics.dep")
}
\references{
Brombacher, E., Schad, A., Kreutz, C. (2020). Tail-Robust
Quantile Normalization. BioRxiv.
}
\seealso{
\code{\link[=example_NApattern]{example_NApattern()}} for description of missing value pattern.
}
\author{
Ariane Schad
}
