% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_corrections.R
\name{mbecSVA}
\alias{mbecSVA}
\title{Surrogate variable Analysis (SVA)}
\usage{
mbecSVA(input.obj, model.vars, type = c("clr", "otu", "tss"))
}
\arguments{
\item{input.obj}{MbecData object}

\item{model.vars}{Vector of covariate names. First element relates to
variable of interest.}

\item{type}{Which abundance matrix to use, one of 'otu, tss, clr'. DEFAULT is
'clr'.}
}
\value{
A vector of p-values that indicate significance of the batch-effect
for the features.
}
\description{
Two step approach that (1.) identify the number of latent factors to be
estimated by fitting a full-model with effect of interest and a null-model
with no effects. The function 'num.sv()' then calculates the number of latent
factors. In the next (2.) step, the sva function will estimate the surrogate
variables. And adjust for them in full/null-model . Subsequent F-test gives
significance values for each feature - these P-values and Q-values are
accounting for surrogate variables (estimated BEs).
}
\details{
The input for this function is supposed to be an MbecData object that
contains total sum-scaled and cumulative log-ratio transformed abundance
matrices. Output will be a vector of p-values.
}
\keyword{Assessment}
\keyword{Batch-Effect}
\keyword{SVA}
