% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_corrections.R
\name{mbecRBE}
\alias{mbecRBE}
\title{Remove Batch Effects (RBE)}
\usage{
mbecRBE(input.obj, model.vars, type = c("clr", "otu", "tss"))
}
\arguments{
\item{input.obj}{phyloseq object or numeric matrix (correct orientation is
handeled internally)}

\item{model.vars}{Vector of covariate names. First element relates to batch.}

\item{type}{Which abundance matrix to use, one of 'otu, tss, clr'. DEFAULT is
'clr'.}
}
\value{
A matrix of batch-effect corrected counts
}
\description{
As part of the limma-package this method was designed to remove BEs from
Microarray Data. The algorithm fits the full-model to the data, i.e., all
relevant covariates whose effect should not be removed, and a model that only
contains the known BEs. The difference between these models produces a
residual matrix that (should) contain only the full-model-effect, e.g.,
treatment. As of now the mbecs-correction only uses the first input for
batch-effect grouping. ToDo: think about implementing a version for more
complex models.
}
\details{
The input for this function is supposed to be an MbecData object that
contains total sum-scaled and cumulative log-ratio transformed abundance
matrices. Output will be a matrix of corrected abundances.
}
\keyword{BECA}
\keyword{Batch}
\keyword{Effects}
\keyword{Limma}
\keyword{Remove}
