% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_analyses.R
\name{mbecModelVariancePVCA}
\alias{mbecModelVariancePVCA}
\title{Estimate Explained Variance with Principal Variance Component Analysis}
\usage{
mbecModelVariancePVCA(
  model.vars,
  tmp.cnts,
  tmp.meta,
  type,
  pct_threshold,
  na.action
)
}
\arguments{
\item{model.vars}{Covariates to use for model building.}

\item{tmp.cnts}{Abundance matrix in 'sample x feature' orientation.}

\item{tmp.meta}{Covariate table that contains at least the used variables.}

\item{type}{String the denotes data source, i.e., one of "otu","clr" or "tss"
for the transformed counts or the label of the batch corrected count-matrix.}

\item{pct_threshold}{Cutoff value for accumulated variance in principal
components.}

\item{na.action}{Set NA handling, will take global option if not supplied.}
}
\value{
Data.frame that contains proportions of variance for given covariates
in a principal variance component analysis approach.
}
\description{
The function offers a selection of methods/algorithms to estimate the
proportion of variance that can be attributed to covariates of interest.
This shows, how much variation is explained by the treatment effect, which
proportion is introduced by processing in batches and the leftover variance,
i.e., residuals that are not currently explained. Covariates of interest
(CoI) are selected by the user and the function will incorporate them into
the model.
}
\details{
Principal Variance Component Analysis (pvca): Algorithm - calculate the
correlation of the fxs count-matrix - from there extract the eigenvectors and
eigenvalues and calculate the proportion of explained variance per
eigenvector (i.e. principal component) by dividing the eigenvalues by the
sum of eigenvalues. Now select as many PCs as required to fill a chosen
quota for the total proportion of explained variance. Iterate over all PCs
and fit a linear mixed model that contains all covariates as random effect
and all unique interactions between two covariates. Compute variance
covariance components form the resulting model --> From there we get the
Variance that each covariate(variable) contributes to this particular PC.
Then just standardize variance by dividing it through the sum of variance for
that model. Scale each PCs results by the proportion this PC accounted for in
the first place. And then do it again by dividing it through the total amount
of explained variance, i.e. the cutoff to select the number of PCs to take
(obviously not the cutoff but rather the actual values for the selected PCs).
Finally take the average over each random variable and interaction term and
display in a nice plot.
}
\keyword{Analysis}
\keyword{Component}
\keyword{Principal}
\keyword{Variance}
