% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_helper.R
\name{mbecLM}
\alias{mbecLM}
\title{Linear (Mixed) Model Feature to Batch Fit}
\usage{
mbecLM(
  input.obj,
  method = c("lm", "lmm"),
  model.vars = c("batch", "group"),
  type = c("clr", "otu", "tss", "cor"),
  label = character()
)
}
\arguments{
\item{input.obj}{MbecData object}

\item{method}{Either 'lm' or 'lmm' for linear models and linear mixed models.}

\item{model.vars}{Covariates of interest, first relates to batch and second
to treatment.}

\item{type}{Which abundance matrix to use, one of 'otu, tss, clr, cor'.
DEFAULT is clr' and the use of 'cor' requires the parameter label to be
set as well.}

\item{label}{Which corrected abundance matrix to use for analysis in case
'cor' was selected as type.}
}
\value{
A vector of fdr corrected p-values that show significance of
treatment for every feature
}
\description{
Helper function that fits lm/lmm with covariates 'treatment' and 'batch' to
every feature in the data-set. Returns the fdr corrected significance value
for the "treatment" variable. The method 'lm' will fit the linear model
\code{y ~ model.vars[1] + model.vars[2]} and the linear mixed model will
consider the second term as random effect, i.e.,
\code{y ~ model.vars[1] + (1|model.vars[2])}.
}
\details{
The function returns either a plot-frame or the finished ggplot object.
Input for th data-set can be an MbecData-object, a phyloseq-object or a list
that contains counts and covariate data. The covariate table requires an
'sID' column that contains sample IDs equal to the sample naming in the
counts table. Correct orientation of counts will be handled internally.
}
\examples{
# This will return p-value for the linear model fit of every feature.
data(dummy.mbec)
val.score <- mbecLM(input.obj=dummy.mbec, model.vars=c("batch","group"),
method="lm")
}
\keyword{Batch}
\keyword{Linear}
\keyword{Mixed}
\keyword{Model}
\keyword{Significance}
