% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_classes.R
\name{mbecGetPhyloseq}
\alias{mbecGetPhyloseq}
\title{Return Phyloseq after correction}
\usage{
mbecGetPhyloseq(
  input.obj,
  type = c("otu", "cor", "clr", "tss"),
  label = character()
)
}
\arguments{
\item{input.obj}{MbecData object}

\item{type}{Specify which type of data to add, by using one of 'cor'
(Correction), 'clr' (Cumulative Log-Ratio) or 'tss' (Total Scaled-Sum).}

\item{label}{For type 'cor' this specifies the name within the
list.}
}
\value{
A phyloseq object that contains the chosen abundance table as
otu_table.
}
\description{
This function extracts the abundance table of choice and returns a phyloseq
object for downstream analyses.
}
\details{
The argument type determines which slot to access, i.e. the base
matrices for un-transformed counts "otu", total sum-scaled counts "tss",
cumulative log-ratio transformed counts "clr" and batch effect corrected
counts "cor". The later additionally requires the use of the argument 'label'
that specifies the name within the list of corrected matrices.
}
\examples{
# This will return a phyloseq object that contains the clr-transformed
# abundances as otu_table
data(dummy.mbec)
ps.clr.obj <- mbecGetPhyloseq(input.obj=dummy.mbec, type="clr")
}
\keyword{Getter}
\keyword{MBECS}
\keyword{Phyloseq}
