% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_plots.R
\name{mbecBoxPlot}
\alias{mbecBoxPlot}
\title{Variability boxes plotting function}
\usage{
mbecBoxPlot(tmp, otu.idx, model.var, label = NULL)
}
\arguments{
\item{tmp}{Count of selected features.}

\item{otu.idx}{Index of selected Otus in the data.}

\item{model.var}{Which covariate to group Otus by.}

\item{label}{Name of the plot displayed as legend title.}
}
\value{
ggplot2 object
}
\description{
Takes data.frame from mbecBox and produces a ggplot2 object.
}
\examples{
# This will return a list of the five most variable features grouped by the
# covariate 'batch'.
data(dummy.mbec)
box.df <- mbecBox(input.obj=dummy.mbec, method='TOP', n=5,
model.var='batch', type="otu", return.data=TRUE)
plot.box <- mbecBoxPlot(box.df[[1]], box.df[[2]], 'batch')
}
\keyword{Abundance}
\keyword{Plot}
\keyword{Variability}
