% Generated by roxygen2 (4.0.1): do not edit by hand
\name{maxLogLikelihoodCalculator2s}
\alias{maxLogLikelihoodCalculator2s}
\title{Function that given observed count data along a known haplotype returns a maximum likelihood estimate of the underlying haplotype frequency.}
\usage{
maxLogLikelihoodCalculator2s(lociHapACountsSample1, lociTotalCountsSample1,
  lociHapACountsSample2, lociTotalCountsSample2, lociHapANoASEProbsSample1,
  lociHapANoASEProbsSample2, lociRhosSample1, lociRhosSample2,
  checkArgs = FALSE)
}
\arguments{
\item{lociHapACountsSample1,lociHapACountsSample2}{counts of haplotype A-supporting reads at individual loci in sample1 and sample2, respectively. Both arguments must be vectors of non-negative integers.}

\item{lociTotalCountsSample1,lociTotalCountsSample2}{total read counts of at individual loci in sample1 and sample2, respectively. Both arguments must be vectors of non-negative integers.}

\item{lociHapANoASEProbsSample1,lociHapANoASEProbsSample2}{probabilities of observing haplotype A-supporting reads at individual loci under conditions of no ASE (e.g., vector with all entries set to 0.5, if there is no pre-existing allelic bias at any locus) in sample1 and sample2, respectively. Both arguments must be vectors with entries >0 and <1.}

\item{lociRhosSample1,lociRhosSample2}{dispersion parameters of beta distribution at individual loci (set to 0 if the read count-generating distribution at the locus is binomial) in sample1 and sample2, respectively. Both arguments must be vectors with entries >=0 and <1.}

\item{checkArgs}{single boolean specifying whether arguments should be checked for adherence to specifications. DEFAULT: FALSE}
}
\value{
a list with two elements: maximum (MLE of haplotype A frequency) and objective (loglikelihood at MLE). These are the two elements that are output by the optimize() function, which is used internally by the maxLogLikelihoodCalculator2s.
}
\description{
Function that given observed count data along a known haplotype returns a maximum likelihood estimate of the underlying haplotype frequency.
}
\details{
Given observed read counts supporting hapltoype A at a collection of loci in two samples, the total read counts at those loci, the probablities of observing haplotype A-supporting reads under conditions of no ASE and the dispersion parameters, this function returns a maximum likelihood estimate of the true underlying frequency of haplotype A as well as corresponding value of log-likelihood.
}
\examples{
MBASED:::maxLogLikelihoodCalculator2s(lociHapACountsSample1=c(5, 12), lociTotalCountsSample1=c(15, 36), lociHapACountsSample2=c(15, 22), lociTotalCountsSample2=c(45, 66), lociHapANoASEProbsSample1=c(0.5, 0.5), lociHapANoASEProbsSample2=c(0.5, 0.5), lociRhosSample1=c(0,0), lociRhosSample2=c(0,0))
}

