% Generated by roxygen2 (4.0.1): do not edit by hand
\name{maxLogLikelihoodCalculator1s}
\alias{maxLogLikelihoodCalculator1s}
\title{Function that given observed count data along a known haplotype returns a maximum likelihood estimate of the underlying haplotype frequency.}
\usage{
maxLogLikelihoodCalculator1s(lociHapACounts, lociTotalCounts,
  lociHapANoASEProbs, lociRhos, checkArgs = FALSE)
}
\arguments{
\item{lociHapACounts}{counts of haplotype A-supporting reads at individual loci. Must be a vector of non-negative integers.}

\item{lociTotalCounts}{total read counts of at individual loci. Must be a vector of positive integers.}

\item{lociHapANoASEProbs}{probabilities of observing haplotype A-supporting reads at individual loci under conditions of no ASE (e.g., vector with all entries set to 0.5, if there is no pre-existing allelic bias at any locus). Must be a vector with entries >0 and <1.}

\item{lociRhos}{dispersion parameters of beta distribution at individual loci (set to 0 if the read count-generating distribution at the locus is binomial). Must be a numeric vector with entries >=0 and <1.}

\item{checkArgs}{single boolean specifying whether arguments should be checked for adherence to specifications. DEFAULT: FALSE}
}
\value{
a list with two elements: maximum (MLE of haplotype A frequency) and objective (loglikelihood at MLE). These are the two elements that are output by the optimize() function, which is used internally by the maxLogLikelihoodCalculator1s.
}
\description{
Function that given observed count data along a known haplotype returns a maximum likelihood estimate of the underlying haplotype frequency.
}
\details{
Given observed read counts supporting hapltoype A at a collection of loci, the total read counts at those loci, the probablities of observing haplotype A-supporting reads under conditions of no ASE and the dispersion parameters, this function returns a maximum likelihood estimate of the true underlying frequency of haplotype A as well as corresponding value of log-likelihood.
}
\examples{
MBASED:::maxLogLikelihoodCalculator1s(lociHapACounts=c(5, 12), lociTotalCounts=c(10, 24), lociHapANoASEProbs=c(0.5, 0.5), lociRhos=c(0,0))
}

