% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSEA-by-boot.R
\name{gseaAfterBoot}
\alias{gseaAfterBoot}
\alias{gsea_control}
\title{Gene set analysis for hurdle model}
\usage{
gseaAfterBoot(
  zFit,
  boots,
  sets,
  hypothesis,
  control = gsea_control(n_randomize = Inf, var_estimate = "bootall")
)

gsea_control(n_randomize = Inf, var_estimate = "bootall")
}
\arguments{
\item{zFit}{object of class ZlmFit}

\item{boots}{bootstraps of zFit}

\item{sets}{list of indices of genes}

\item{hypothesis}{a \code{Hypothesis} to test. Currently only one degree \code{CoefficientHypothesis} are supported.}

\item{control}{parameters as provided by \code{gsea_control}.  See details.}

\item{n_randomize}{the number of genes to sample to approximate the non-module average expression. Set to \code{Inf} to turn off the approximation (the default).}

\item{var_estimate}{the method used to estimate the variance of the modules, one of \code{bootall}, \code{bootdiag}, or \code{modelbased}.}
}
\value{
Object of class \code{GSEATests}, containing slots \code{tests},  4D array and \code{bootR}, the number of boostrap replicates.
}
\description{
Modules defined in \code{sets} are tested for average differences in expression from the "average" gene.
By using bootstraps, the between-gene covariance of terms in the hurdle model is found, and is used to adjust for coexpression between genes.
We drop genes if the coefficient we are testing was not estimible in original model fit in \code{zFit} or in any of the bootstrap replicates (evidenced an \code{NA} in the bootstrap array).  This might yield overly conservative inference.
Since bootstrapping is a randomized procedure, the degrees of freedom of a module (and its variance parameters) might differ from run-to-run.
You might try setting \code{var_estimate='modelbased'} to relax this requirement by assuming independence between genes and then using the asymptotic covariance estimates, which are deterministic, but may result in overly-generous inference.
}
\section{Functions}{
\itemize{
\item \code{gsea_control()}: set control parameters.  See Details.

}}
\section{\code{control}}{

\code{control} is a list with elements:
\itemize{
\item \code{n_randomize}, giving the number of genes to sample to approximate the non-module average expression. Set to \code{Inf} to turn off the approximation (the default).
\item \code{var_estimate}, giving the method used to estimate the variance of the modules.  \code{bootall} uses the bootstrapped covariance matrices.  \code{bootdiag} uses only the diagonal of the bootstrapped covariance matrix (so assuming independence across genes). \code{modelbased} assumes independence across genes and uses the variance estimated from the model.}
}

\section{Return Value}{

A 4D array is returned, with  dimensions "set" (each module), "comp" ('disc'rete or 'cont'inuous), "metric" ('stat' gives the average of the coefficient, 'var' gives the variance of that average, 'dof' gives the number of genes that were actually tested in the set), "group" ('test' for the genes in test-set, "null" for all genes outside the test-set).
}

\examples{
data(vbetaFA)
vb1 = subset(vbetaFA, ncells==1)
vb1 = vb1[,freq(vb1)>.1][1:15,]
zf = zlm(~Stim.Condition, vb1)
boots = bootVcov1(zf, 5)
sets = list(A=1:5, B=3:10, C=15, D=1:5)
gsea = gseaAfterBoot(zf, boots, sets, CoefficientHypothesis('Stim.ConditionUnstim'))
## Use a model-based estimate of the variance/covariance.
gsea_mb = gseaAfterBoot(zf, boots, sets, CoefficientHypothesis('Stim.ConditionUnstim'),
control = gsea_control(var_estimate = 'modelbased'))
calcZ(gsea)
summary(gsea)
\dontshow{
stopifnot(all.equal(gsea@tests['A',,,],gsea@tests['D',,,]))
stopifnot(all.equal(gsea@tests['C','cont','stat','test'], coef(zf, 'C')[15,'Stim.ConditionUnstim']))
}
}
\seealso{
\link{calcZ}

summary,GSEATests-method
}
