% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleCellAssay-methods.R
\name{split,SingleCellAssay,character-method}
\alias{split,SingleCellAssay,character-method}
\alias{split,SingleCellAssay,factor-method}
\alias{split,SingleCellAssay,list-method}
\title{Split into \code{list}}
\usage{
\S4method{split}{SingleCellAssay,character}(x, f, drop = FALSE, ...)
}
\arguments{
\item{x}{SingleCellAssay}

\item{f}{length-1 character, or atomic of length ncol(x)}

\item{drop}{drop unused factor levels}

\item{...}{ignored}
}
\value{
List
}
\description{
Splits a \code{SingleCellAssay} into a \code{list} by a factor (or something coercible into a factor) or a character giving a column of \code{colData(x)}
}
\examples{
data(vbetaFA)
split(vbetaFA, 'ncells')
fa <- as.factor(colData(vbetaFA)$ncells)
split(vbetaFA, fa)

}
