% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{qtlUpsetPlot}
\alias{qtlUpsetPlot}
\title{qtlUpsetPlot}
\usage{
qtlUpsetPlot(meth.qtl.result.list, type = "SNP", ...)
}
\arguments{
\item{meth.qtl.result.list}{A named list with each entry being an object of type \code{\link{MethQTLResult-class}}.
The names are used in the visualization.}

\item{type}{Determines if either the SNP (default), the CpG, or the correlation block
\code{'cor.block'} is to be visualized}

\item{...}{Further argument passed to \code{\link[UpSetR]{upset}}}
}
\value{
None
}
\description{
This function creates an UpSet plot from the given methQTL results
}
\details{
The plot is directly drawn and can be stored on disk using the known R graphic devices
}
\examples{
meth.qtl.res.1 <- loadMethQTLResult(system.file("extdata","MethQTLResult_chr18",package="MAGAR"))
meth.qtl.res.2 <- meth.qtl.res.1
qtlUpsetPlot(list(A=meth.qtl.res.1,B=meth.qtl.res.2))
}
\author{
Michael Scherer
}
