% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethQTLInput-class.R, R/MethQTLResult-class.R
\docType{methods}
\name{getAnno,MethQTLInput-method}
\alias{getAnno,MethQTLInput-method}
\alias{getAnno,methQTL-method}
\alias{getAnno}
\alias{getAnno,MethQTLResult-method}
\title{getAnno}
\usage{
\S4method{getAnno}{MethQTLInput}(object, type = "meth")

\S4method{getAnno}{MethQTLResult}(object, type = "meth")
}
\arguments{
\item{object}{An object of class \code{\link{MethQTLInput-class}} or \code{\link{MethQTLResult-class}}.}

\item{type}{The type of annotation to be returned. Can either be \code{'meth'} or \code{'geno'} for methylation,
and genotyping information, respectively.}
}
\value{
The genomic annotation as a \code{data.frame}.
}
\description{
Returns genomic annotation information for the given dataset.
}
\examples{
meth.qtl <- loadMethQTLInput(system.file("extdata","reduced_methQTL",package="MAGAR"))
head(getAnno(meth.qtl,"meth"))
head(getAnno(meth.qtl,"geno"))
meth.qtl.res <- loadMethQTLResult(system.file("extdata","MethQTLResult_chr18",package="MAGAR"))
head(getAnno(meth.qtl.res,"meth"))
head(getAnno(meth.qtl.res,"geno"))
}
