% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_pwm.r
\name{viewPWM}
\alias{viewPWM}
\title{View motif}
\usage{
viewPWM(pwm_in = NULL, which_pwm = NULL, fontsize = 10,
  view_pwm = FALSE, pseudo = 0.01, convert_PWM = FALSE,
  color_scheme = "shapely", correction_factor = NULL)
}
\arguments{
\item{pwm_in}{View a PWM provided using the buildPWM. Default = NULL}

\item{which_pwm}{If pwms are input (outputs of buildPWM), a kinase name must
match a name in pwms$kinase$kinase list of names. Default = NULL}

\item{fontsize}{Font size to use on x and y axis. Default = 10}

\item{view_pwm}{View the PWM. Default = FALSE}

\item{pseudo}{Small amount added to the PWM model, where zero's exist, to 
avoid log zero. Default = 0.01}

\item{convert_PWM}{pwm_in is a matrix of counts at position. TRUE will 
convert this matrix to a PWM. Default = FALSE}

\item{color_scheme}{Which color scheme to use for Amino Acid Groups. Options
are "lesk" or "shapely". Default = "shapely"}

\item{correction_factor}{Number of sequences used to infer the PWM. 
This can be used where a small number of sequences were used to build the 
model and included as E_n in the Shannon's Entropy Model. Default = NULL}
}
\value{
Visualisation of a motif, scaled on bits and two tables. 1) pwm: 
corresponding to the PWM from pwm and 2) pwm_bits: corresponding to the
conversion to bits.
}
\description{
View information content for each position of the PWM.
Information content is modelled using Shannon's Entropy Model. The maximum
information content is therefore log2(n), where n is the number of amino
acids. Colors of Amino Acids are in accordance with the Lesk scheme.
}
\examples{
## Build PWM models from phosphositeplus data with default of minimum
## of 10 substrate sequences for building a PWM model.
data(phosphositeplus_human)
##randomly sample 1000 substrates for demonstration.
set.seed(1)
sample_pwm <- phosphositeplus_human[sample(nrow(phosphositeplus_human), 
1000),]
pwms <- buildPWM(sample_pwm)

## Data frame of models built and number of sequences used to build each
## PWM model:
head(pwms$kinase)
## Will not visualise the motif
CAMK2A_motif <- viewPWM(pwm_in = pwms, 
                        which_pwm = "CAMK2A",
                        view_pwm = FALSE)
# Use view_pwm = TRUE to view the motif
}
