% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretization.measure.R
\name{discretize1D}
\alias{discretize1D}
\title{Discretize one-dimensional continuous data into bins}
\usage{
discretize1D(x, algorithm = c("uniform_width", "uniform_frequency"))
}
\arguments{
\item{x}{a numeric vector of the random variable x.}

\item{algorithm}{two discretization algorithms are available, "uniform_width" is the default.}
}
\value{
discretize1D returns a one-dimensional count table.
}
\description{
The function of discretize1D is used to assign the observations of a set of continuous random variables to bins,
and returns a corresponding one-dimensional count table. Two of the most common discretization methods are available:
"uniform width" and "uniform frequency".
}
\details{
Uniform width-based method ("uniform_width") divides the continuous data into N bins with equal width,
while Uniform frequency-based method ("uniform_frequency") divides the continuous data into N bins with (approximate) equal count number.
By default in both methods, the number of bins N is initialized into a round-off value according to the square root of the data size.
}
\examples{
# a numeric vector corresponding to a continuous random variable
x <- c(0.0, 0.2, 0.2, 0.7, 0.9, 0.9, 0.9, 0.9, 1.0)

# corresponding count table estimated by "uniform width" algorithm
discretize1D(x, "uniform_width")

# corresponding count table estimated by "uniform frequency" algorithm
discretize1D(x, "uniform_frequency")
}
