% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information.plugin.R
\name{PID.plugin}
\alias{PID.plugin}
\title{A plug-in calculator for evaluating partial information decomposition}
\usage{
PID.plugin(probs, unit = c("log", "log2", "log10"))
}
\arguments{
\item{probs}{the joint probability distribution of three random variables.}

\item{unit}{the base of the logarithm. The default is natural logarithm, which is "log".
For evaluating entropy in bits, it is suggested to set the unit to "log2".}
}
\value{
PID.plugin returns a list that includes synergistic information, unique information from source x,
unique information from source y, redundant information and the sum of the four parts of information.
}
\description{
PID.plugin decomposes two source information acting on the common target into four parts: joint information (synergy),
unique information from source x, unique information from source y and shared information (redundancy).
The input of PMI.plug is the joint probability distribution table.
}
\examples{
# three numeric vectors corresponding to three continuous random variables
x <- c(0.0, 0.2, 0.2, 0.7, 0.9, 0.9, 0.9, 0.9, 1.0)
y <- c(1.0, 2.0,  12, 8.0, 1.0, 9.0, 0.0, 3.0, 9.0)
z <- c(3.0, 7.0, 2.0,  11,  10,  10,  14, 2.0,  11)

# corresponding joint count table estimated by "uniform width" algorithm
count_xyz <- discretize3D(x, y, z, "uniform_width")

# the joint probability distribution table of the count data
library("entropy")
probs_xyz <- freqs.empirical(count_xyz)

# corresponding partial information decomposition
PID.plugin(probs_xyz)
}
\references{
Williams, P. L., & Beer, R. D. (2010). Nonnegative Decomposition of Multivariate Information. arXiv: Information Theory.

Chan, T. E., Stumpf, M. P., & Babtie, A. C. (2017). Gene Regulatory Network Inference from Single-Cell Data Using Multivariate Information Measures.
Cell systems, 5(3).
}
