% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information.plugin.R
\name{II.plugin}
\alias{II.plugin}
\title{A plug-in calculator for evaluating the interaction information}
\usage{
II.plugin(probs, unit = c("log", "log2", "log10"))
}
\arguments{
\item{probs}{the joint probability distribution table of three random variables.}

\item{unit}{the base of the logarithm. The default is natural logarithm, which is "log".
For evaluating entropy in bits, it is suggested to set the unit to "log2".}
}
\value{
II.plugin returns the interaction information.
}
\description{
II.plugin measures the amount information contained in a set of variables from the joint probability distribution table.
The number of variables here is limited to three.
}
\examples{
# three numeric vectors corresponding to three continuous random variables
x <- c(0.0, 0.2, 0.2, 0.7, 0.9, 0.9, 0.9, 0.9, 1.0)
y <- c(1.0, 2.0,  12, 8.0, 1.0, 9.0, 0.0, 3.0, 9.0)
z <- c(3.0, 7.0, 2.0,  11,  10,  10,  14, 2.0,  11)

# corresponding joint count table estimated by "uniform width" algorithm
count_xyz <- discretize3D(x, y, z, "uniform_width")

# the joint probability distribution table of the count data
library("entropy")
probs_xyz <- freqs.empirical(count_xyz)

# corresponding interaction information
II.plugin(probs_xyz)
}
\references{
Mcgill, W. J. (1954). Multivariate information transmission. Psychometrika, 19(2), 97-116.
}
