% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InTADSig-methods.R
\name{loadSigInTAD}
\alias{loadSigInTAD}
\title{Load InTADSig object from text files}
\usage{
loadSigInTAD(signalsFile, countsFile, gtfFile, annFile = "",
  performLog = TRUE, logExprsOffset = 1, ncores = 1)
}
\arguments{
\item{signalsFile}{Tab-seprated data table containg signals and their
coordinates as row.names}

\item{countsFile}{Tab-seprated counts table}

\item{gtfFile}{GTF file containing all gene coordinates}

\item{annFile}{Tab-delimited phenotype annotation of samples}

\item{performLog}{Perform log2 convertion of expression values.
Default: TRUE.}

\item{logExprsOffset}{Offset x for log2 gene exrpression
i.e. log2(value + x). Default: 1}

\item{ncores}{Number of cores to use for parallel computing}
}
\value{
Novel InTADSig object
}
\description{
The fuction loads the data tables to create an object that contains the
signals and gene expression data.frames along with their genomic coordinates
for further processing.
}
\details{
The function loads data from input files and creates object that stores
matrices of signals and gene expression values along with coordiantes.
The samples order and names of columns should match in both tables.
It is expected that gene ids are applied in the validation of counts table.
}
\examples{
# create sigInTAD object
inTadSig <- newSigInTAD(enhSel, enhSelGR, rpkmCountsSel, txsSel)


}
