% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/15.search_proximalCPs.R
\name{search_proximalCPs}
\alias{search_proximalCPs}
\title{search proximal CPsites}
\usage{
search_proximalCPs(
  CPs,
  curr_UTR,
  window_size,
  MINSIZE,
  cutEnd = NA,
  search_point_START,
  search_point_END = NA,
  filter.last = TRUE,
  DIST2END = 1000
)
}
\arguments{
\item{CPs}{output from \code{\link[=search_distalCPs]{search_distalCPs()}}}

\item{curr_UTR}{GRanges for current 3' UTR}

\item{window_size}{window size}

\item{MINSIZE}{MINSIZE for short form}

\item{cutEnd}{A numeric(1) between 0 and 1 or an integer(1) greater than 1,
specifying the percentage of or the number of nucleotides should be removed
from the end before search for proximal CP sites, 0.1 means 10 percent.
It is recommended to use an integer great than 1, such as 200, 400 or 600,
because read coverage at 3' extremities is determined by fragment size due
to RNA fragmentation and size selection during library construction.}

\item{search_point_START}{An integer, specifying the start position to
calculate MSE}

\item{search_point_END}{A numeric(1) between 0 and 1 or an integer(1) greater
than 1, specifying the percentage of or the number of nucleotides should not
be excluded from the end to calculate MSE.}

\item{filter.last}{A logical(1), whether to filter out the last valley, which
is likely the 3' end of the longer 3' UTR if no novel distal CP site is
detected and the 3' end excluded by setting cutEnd/search_point_END is small.}

\item{DIST2END}{An integer, specifying a cutoff of the distance between last valley
and the end of the 3' UTR (where MSE of the last base is calculated). If
the last valley is closer to the end than the specified distance, it will be
not be considered because it is very likely due to RNA coverage decay at the
end of mRNA. Default is 1200. User can consider a value between 1000 and
1500, depending on the library preparation procedures: RNA fragmentation and
size selection.}
}
\value{
a list
}
\description{
search proximal CPsites
}
\seealso{
\code{\link[=adjust_proximalCPs]{adjust_proximalCPs()}}, \code{\link[=polish_CPs]{polish_CPs()}},\code{\link[=adjust_proximalCPsByPWM]{adjust_proximalCPsByPWM()}},
\code{\link[=adjust_proximalCPsByNBC]{adjust_proximalCPsByNBC()}}, \code{\link[=get_PAscore]{get_PAscore()}}, \code{\link[=get_PAscore2]{get_PAscore2()}}
}
\author{
Jianhong Ou
}
\keyword{internal}
