% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06.run_coverageQC.R
\name{run_coverageQC}
\alias{run_coverageQC}
\title{Quality control on read coverage over gene bodies and 3UTRs}
\usage{
run_coverageQC(
  sqlite_db,
  TxDb = getInPASTxDb(),
  edb = getInPASEnsDb(),
  genome = getInPASGenome(),
  cutoff_readsNum = 1,
  cutoff_expdGene_cvgRate = 0.1,
  cutoff_expdGene_sampleRate = 0.5,
  chr2exclude = getChr2Exclude(),
  which = NULL,
  future.chunk.size = 1,
  ...
)
}
\arguments{
\item{sqlite_db}{A path to the SQLite database for InPAS, i.e. the output of
\code{\link[=setup_sqlitedb]{setup_sqlitedb()}}.}

\item{TxDb}{An object of \link[GenomicFeatures:TxDb-class]{GenomicFeatures::TxDb}}

\item{edb}{An object of \link[ensembldb:EnsDb-class]{ensembldb::EnsDb}}

\item{genome}{An object of \link[BSgenome:BSgenome-class]{BSgenome::BSgenome}}

\item{cutoff_readsNum}{cutoff reads number. If the coverage in the location
is greater than cutoff_readsNum,the location will be treated as covered by
signal}

\item{cutoff_expdGene_cvgRate}{cutoff_expdGene_cvgRate and
cutoff_expdGene_sampleRate are  the  parameters used to calculate which
gene is expressed in all input dataset. cutoff_expdGene_cvgRateset the
cutoff value for the coverage rate of each gene;
cutoff_expdGene_sampleRateset the cutoff value for ratio of numbers of
expressed and all samples for each gene. for example, by default,
cutoff_expdGene_cvgRate=0.1 and cutoff_expdGene_sampleRate=0.5,suppose
there are 4 samples, for one gene, if the coverage rates by base are:0.05,
0.12, 0.2, 0.17, this gene will be count as expressed gene because
mean(c(0.05,0.12, 0.2, 0.17) > cutoff_expdGene_cvgRate) >
cutoff_expdGene_sampleRate if the coverage rates by base are: 0.05, 0.12,
0.07, 0.17, this gene will be count as un-expressed gene because
mean(c(0.05, 0.12, 0.07, 0.17) > cutoff_expdGene_cvgRate)<=
cutoff_expdGene_sampleRate}

\item{cutoff_expdGene_sampleRate}{See cutoff_expdGene_cvgRate}

\item{chr2exclude}{A character vector, NA or NULL, specifying chromosomes or
scaffolds to be excluded for InPAS analysis. \code{chrM} and alternative scaffolds
representing different haplotypes should be excluded.}

\item{which}{an object of \link[GenomicRanges:GRanges-class]{GenomicRanges::GRanges} or NULL. If it is
not NULL, only the exons overlapping the given ranges are used. For fast
data quality control, set which to Granges for one or a few large
chromosomes.}

\item{future.chunk.size}{The average number of elements per future
("chunk"). If Inf, then all elements are processed in a single future.
If NULL, then argument future.scheduling = 1 is used by default. Users can
set future.chunk.size = total number of elements/number of cores set for
the backend. See the future.apply package for details.}

\item{...}{Not used yet}
}
\value{
A data frame as described below.
\describe{
\item{gene.coverage.rate}{overage per base for
all genes}
\item{expressed.gene.coverage.rate}{coverage per base for expressed
genes}
\item{UTR3.coverage.rate}{coverage per base for all 3'
UTRs}
\item{UTR3.expressed.gene.subset.coverage.rate}{coverage per base for 3'
UTRs of expressed genes}
\item{rownames}{the names of coverage}
}
}
\description{
Calculate coverage over gene bodies and 3UTRs. This function is used for
quality control of the coverage.The coverage rate can show the complexity of
RNA-seq library.
}
\examples{
if (interactive()) {
  library("BSgenome.Mmusculus.UCSC.mm10")
  library("TxDb.Mmusculus.UCSC.mm10.knownGene")
  library("EnsDb.Mmusculus.v79")

  genome <- BSgenome.Mmusculus.UCSC.mm10
  TxDb <- TxDb.Mmusculus.UCSC.mm10.knownGene
  edb <- EnsDb.Mmusculus.v79

  bedgraphs <- system.file("extdata", c(
    "Baf3.extract.bedgraph",
    "UM15.extract.bedgraph"
  ),
  package = "InPAS"
  )
  tags <- c("Baf3", "UM15")
  metadata <- data.frame(
    tag = tags,
    condition = c("Baf3", "UM15"),
    bedgraph_file = bedgraphs
  )
  outdir <- tempdir()
  write.table(metadata,
    file = file.path(outdir, "metadata.txt"),
    sep = "\t", quote = FALSE, row.names = FALSE
  )

  sqlite_db <- setup_sqlitedb(
    metadata = file.path(
      outdir,
      "metadata.txt"
    ),
    outdir
  )
  tx <- parse_TxDb(
    sqlite_db = sqlite_db,
    TxDb = TxDb,
    edb = edb,
    genome = genome,
    outdir = outdir,
    chr2exclude = "chrM"
  )
  addLockName(filename = tempfile())
  coverage <- list()
  for (i in seq_along(bedgraphs)) {
    coverage[[tags[i]]] <- get_ssRleCov(
      bedgraph = bedgraphs[i],
      tag = tags[i],
      genome = genome,
      sqlite_db = sqlite_db,
      outdir = outdir,
      chr2exclude = "chrM"
    )
  }
  chr_coverage <- assemble_allCov(sqlite_db,
    seqname = "chr6",
    outdir,
    genome
  )
  run_coverageQC(sqlite_db, TxDb, edb, genome,
    chr2exclude = "chrM",
    which = GRanges("chr6",
      ranges = IRanges(98013000, 140678000)
    )
  )
}
}
\author{
Jianhong Ou, Haibo Liu
}
