% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate-functions.R
\name{aggregate_metadata}
\alias{aggregate_metadata}
\title{Performs aggregation on metadata contained in the association file.}
\usage{
aggregate_metadata(
  association_file,
  grouping_keys = c("SubjectID", "CellMarker", "Tissue", "TimePoint"),
  aggregating_functions = default_meta_agg(),
  import_stats = lifecycle::deprecated()
)
}
\arguments{
\item{association_file}{The imported association file
(via \link{import_association_file})}

\item{grouping_keys}{A character vector of column names to form a grouping
operation}

\item{aggregating_functions}{A data frame containing specifications
of the functions to be applied to columns in the association file during
aggregation. It defaults to \link{default_meta_agg}. The structure of
this data frame should be maintained if the user wishes to change the
defaults.}

\item{import_stats}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} The import
of VISPA2 stats has been moved to its dedicated function,
see \link{import_Vispa2_stats}.}
}
\value{
An aggregated data frame
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Groups metadata by the specified grouping keys and returns a
summary of info for each group. For more details on how to use this function:
\code{vignette("workflow_start", package = "ISAnalytics")}
}
\examples{
data("association_file", package = "ISAnalytics")
aggreg_meta <- aggregate_metadata(
    association_file = association_file
)
head(aggreg_meta)
}
\seealso{
Other Data cleaning and pre-processing: 
\code{\link{aggregate_values_by_key}()},
\code{\link{compute_near_integrations}()},
\code{\link{default_meta_agg}()},
\code{\link{outlier_filter}()},
\code{\link{outliers_by_pool_fragments}()},
\code{\link{purity_filter}()},
\code{\link{realign_after_collisions}()},
\code{\link{remove_collisions}()},
\code{\link{threshold_filter}()}
}
\concept{Data cleaning and pre-processing}
