% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{refGenes_hg38}
\alias{refGenes_hg38}
\alias{refGenes_mm10}
\title{Reference gene annotation for hg38 or mm10.}
\format{
A tibble with one row per gene and the following columns:
\describe{
\item{name2}{Gene symbol (e.g., A1CF)}
\item{chrom}{Chromosome (e.g., chr10)}
\item{strand}{Strand direction, "+" or "-"}
\item{min_txStart}{Minimum transcript start position across all isoforms}
\item{max_txEnd}{Maximum transcript end position across all isoforms}
\item{minmax_TxLen}{Gene length computed as max_txEnd - min_txStart}
\item{average_TxLen}{Average transcript length across isoforms}
\item{name}{Transcript ID (typically Ensembl ID in hg38, e.g., ENST00000...)}
\item{min_cdsStart}{Minimum CDS start position}
\item{max_cdsEnd}{Maximum CDS end position}
\item{minmax_CdsLen}{CDS length computed as max_cdsEnd - min_cdsStart}
\item{average_CdsLen}{Average CDS length across isoforms}
}

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 55316 rows and 12 columns.
}
\source{
UCSC Genome Browser: \url{https://hgdownload.soe.ucsc.edu/goldenPath/hg38/database/}

UCSC Genome Browser: \url{https://hgdownload.soe.ucsc.edu/goldenPath/mm10/database/}
}
\usage{
data("refGenes_hg38")

data("refGenes_mm10")
}
\description{
A gene-level annotation dataset derived from the UCSC knownGene and kgXref tables
for the hg38 or mm10 genome assembly. This data aggregates transcript-level information into
gene-level summary statistics, including transcript span, CDS length, and average values
across isoforms. It is the hg38 equivalent of \code{refGenes_hg19},
or mm10 equivalent of \code{refGenes_mm9}, updated using Ensembl-based
transcript IDs from GENCODE.

These objects are tibbles (\code{tbl_df}) and inherit from \code{data.frame}.
}
\section{Functions}{
\itemize{
\item \code{refGenes_mm10}: Data frame for murine mm10 genome

}}
\keyword{datasets}
