% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap-up-functions.R
\name{inspectFromBAM}
\alias{inspectFromBAM}
\title{Wrapper function from BAM files}
\usage{
inspectFromBAM(
  txdb,
  annotation_table,
  labeling_time = NULL,
  strandSpecific = 0,
  isPairedEnd = FALSE,
  estimateRatesWith = "der",
  useSigmoidFun = TRUE,
  file = NULL
)
}
\arguments{
\item{txdb}{A TranscriptDB object for the selected organism}

\item{annotation_table}{Paths and experimental design associated to bam files. They could be
provided directly as a 'data.frame', or as a path to the file containing the information. Possible file
formats are csv' (comma-separated-values), 'tsv' (comma-separated-values), or 'xls' (Excel).
In case 'annotation_table' has 2 colums named 'condition' and 'total', INSPEcT- analysis is run.
In case 'annotation_table' has 3 colums named 'condition', 'total' and 'nascent', INSPEcT+ analysis is run.
'condition' is a colums indicating the experimental condition, a character vector (containing, for example, 'WT'
or 'KD') in case of steady-state experiments, or numerical values indicating the time from the unperturbed
condition in case of time-course analysis. 'total' and 'nascent' contains the path to totalRNA and nascentRNA
BAM files, respectively.}

\item{labeling_time}{A numeric indicating the time of labeling exposure to the modified nucleotide.
To be indicated only in case of INSPEcT+ analysis.}

\item{strandSpecific}{A numeric indicating the strandness of the BAM files, 0 for non strand-specific,
1 for stranded, 2 for reversely-stranded. 0 by default.}

\item{isPairedEnd}{A logical indicating if paired-end sequencing have been performed. FALSE by default.}

\item{estimateRatesWith}{Either "int" or "der". With "int" the degradation and processing
rates are estimated integrating the system between one time point and the following. 
With "der" degradation and processing rates are estimated using the derivative of total
and pre mRNA. (default is "der")}

\item{useSigmoidFun}{A logical, whether to choose between sigmoid and impulse function 
to fit rates and concentrations. In case not, always impulse function is used. 
(default is TRUE)}

\item{file}{A character indicating where the output of the analysis will be stored. If not provided 
the file name will be created automaticcally and saved on the current folder.}
}
\description{
Function to run the whole INSPEcT differential rate analysis procedure with a single line. 
The function save the output analysis to file that can be later loaded in the R environment 
or in the INSPEcT-GUI.
}
