% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/geneClass-methods.R,
%   R/steady-state-methods.R
\name{geneClass}
\alias{geneClass}
\alias{geneClass,INSPEcT-method}
\alias{geneClass,INSPEcT_model-method}
\alias{geneClass,INSPEcT_diffsteady-method}
\title{Retrieve the regulatory class for each gene}
\usage{
geneClass(object, ...)

\S4method{geneClass}{INSPEcT}(object, ...)

\S4method{geneClass}{INSPEcT_model}(object, ...)

\S4method{geneClass}{INSPEcT_diffsteady}(object, ...)
}
\arguments{
\item{object}{An object of class INSPEcT or INSPEcT_model}

\item{...}{specify the threshold for rate variability 'bTsh' in case of 'INSPEcT_diffsteady' objects (default = .1)}
}
\value{
A character containing the regulatory class for each gene
}
\description{
This method returns a factor that summarise the gene class (transcriptional regulatory mechanism) that
INSPEcT has assigned to each gene. The variability of each rate is indicated with a letter, 's' for
synthesis, 'p' for processing and 'd' for degradation. In case more than one rate is variable, the 
letters associated to each variable rate are merged, for example 'sd' stands for a gene where synthesis
and degradation cotributed to transcriptional changes. 'no-reg' is associated to genes with no
change in transcription. The classification depends on the thresholds of the goodness-of-fit and
rate variability tests that can be changed via the method \code{\link{calculateRatePvals}}.
}
\examples{
nascentInspObj10 <- readRDS(system.file(package='INSPEcT', 'nascentInspObj10.rds'))
geneClass(nascentInspObj10)
# see the classification with another threshold for rate variability
nascentInspObj10 <- calculateRatePvals(nascentInspObj10, p_variability=rep(1,3))
geneClass(nascentInspObj10)
}
\seealso{
\code{\link{ratePvals}}
}
