% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/AllGenerics.R,
%   R/show-methods.R, R/steady-state-methods.R
\docType{class}
\name{INSPEcT_diffsteady-class}
\alias{INSPEcT_diffsteady-class}
\alias{synthesis}
\alias{processing}
\alias{degradation}
\alias{show,INSPEcT_diffsteady-method}
\alias{synthesis,INSPEcT_diffsteady-method}
\alias{processing,INSPEcT_diffsteady-method}
\alias{degradation,INSPEcT_diffsteady-method}
\alias{featureNames,INSPEcT_diffsteady-method}
\title{An S4 class to represent comparisons between two steady-state conditions}
\usage{
synthesis(object)

processing(object)

degradation(object)

\S4method{show}{INSPEcT_diffsteady}(object)

\S4method{synthesis}{INSPEcT_diffsteady}(object)

\S4method{processing}{INSPEcT_diffsteady}(object)

\S4method{degradation}{INSPEcT_diffsteady}(object)

\S4method{featureNames}{INSPEcT_diffsteady}(object)
}
\arguments{
\item{object}{An object of class INSPEcT_model}
}
\value{
Method show for objects of class INSPEcT_model returns the number of
the genes that have been modeled
}
\description{
INSPEcT_diffsteady is a class able to store the results of the comparisons between two steady states.
An object of class INSPEcT_diffsteady is created with the method "compareSteady" applied on 
two "INSPEcT" objects (see \code{\link{compareSteady}}).
}
\details{
Methods associated to the class INSPEcT_diffsteady are:
\itemize{
  \item synthesis: Accessor to the synthesis rates and their comparisons.
  \item degradation: Accessor to the degradation rates and their comparisons.
  \item processing: Accessor to the processing rates and their comparisons.
 \item plotMA: visualization fuction for rates comparisons, see \code{\link{plotMA}}
}
}
\section{Slots}{

\describe{
\item{\code{synthesis}}{A data.frame which contains both input data and comparisons results regarding
synthesis rates}

\item{\code{degradation}}{A data.frame which contains both input data and comparisons results regarding
degradation rates}

\item{\code{processing}}{A data.frame which contains both input data and comparisons results regarding
processing rates}

\item{\code{modeling_res}}{A data.frame which contains modeling results}
}}

\examples{
if( Sys.info()["sysname"] != "Windows" ) {
  data('allcounts', package='INSPEcT')
  data('featureWidths', package='INSPEcT')
  data('libsizes', package='INSPEcT')
  
  nascentCounts<-allcounts$nascent
  matureCounts<-allcounts$mature
  conditions<-letters[1:11]
  expDes<-rep(conditions,3)
  tL<-1/6
  
  nasExp_DESeq2<-quantifyExpressionsFromTrCounts(
        allcounts=nascentCounts
        ,libsize=nascentLS
        ,exonsWidths=exWdths
        ,intronsWidths=intWdths
        ,experimentalDesign=expDes)
  
  matExp_DESeq2<-quantifyExpressionsFromTrCounts(
        allcounts=matureCounts
        ,libsize=totalLS
        ,exonsWidths=exWdths
        ,intronsWidths=intWdths
        ,experimentalDesign=expDes)
 
  nasFullObj <- newINSPEcT(tpts=conditions,labeling_time=tL
        ,nascentExpressions=nasExp_DESeq2,matureExpressions=matExp_DESeq2)
  
  diffrates = compareSteady(nasFullObj[,c(1,11)])
  head(synthesis(diffrates))
}
if( Sys.info()["sysname"] != "Windows" ) {
  head(processing(diffrates))
}
if( Sys.info()["sysname"] != "Windows" ) {
  head(degradation(diffrates))
}
if( Sys.info()["sysname"] != "Windows" ) {
  featureNames(diffrates)
}
}
