% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{GeneHeatmap}
\alias{GeneHeatmap}
\alias{GeneHeatmap.SingleCellExperiment}
\alias{GeneHeatmap,SingleCellExperiment-method}
\title{Heatmap visualization of the gene markers identified by FindAllGeneMarkers}
\usage{
GeneHeatmap.SingleCellExperiment(object, clustering.type, gene.markers)

\S4method{GeneHeatmap}{SingleCellExperiment}(object, clustering.type = "manual", gene.markers = NULL)
}
\arguments{
\item{object}{of \code{SingleCellExperiment} class}

\item{clustering.type}{"manual" or "optimal". "manual" refers to the
clustering formed using the "SelectKClusters" function and "optimal"
to the clustering using the "CalcSilhInfo" function.
Default is "manual".}

\item{gene.markers}{a data frame of the gene markers generated
by FindAllGeneMarkers function. To accelerate the drawing, filtering
the dataframe by selecting e.g. top 10 genes is recommended.}
}
\value{
nothing
}
\description{
The GeneHeatmap function enables drawing a heatmap of the gene markers
identified by FindAllGeneMarkers, where the cell are grouped
by the clustering.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(logcounts = pbmc3k_500))
sce <- PrepareILoReg(sce)
## These settings are just to accelerate the example, use the defaults.
sce <- RunParallelICP(sce,L=2,threads=1,C=0.1,r=1,k=5) # Use L=200
sce <- RunPCA(sce,p=5)
sce <- HierarchicalClustering(sce)
sce <- SelectKClusters(sce,K=5)
gene_markers <- FindAllGeneMarkers(sce,log2fc.threshold = 0.5,min.pct = 0.5)
top10_log2FC <- SelectTopGenes(gene_markers,top.N=10,
criterion.type="log2FC",inverse=FALSE)
GeneHeatmap(sce,clustering.type = "manual",
 gene.markers = top10_log2FC)

}
\keyword{gene}
\keyword{grouped}
\keyword{heatmap}
