% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{FindAllGeneMarkers}
\alias{FindAllGeneMarkers}
\alias{FindAllGeneMarkers.SingleCellExperiment}
\alias{FindAllGeneMarkers,SingleCellExperiment-method}
\title{identification of gene markers for all clusters}
\usage{
FindAllGeneMarkers.SingleCellExperiment(
  object,
  clustering.type,
  test,
  log2fc.threshold,
  min.pct,
  min.diff.pct,
  min.cells.group,
  max.cells.per.cluster,
  pseudocount.use,
  return.thresh,
  only.pos
)

\S4method{FindAllGeneMarkers}{SingleCellExperiment}(
  object,
  clustering.type = "manual",
  test = "wilcox",
  log2fc.threshold = 0.25,
  min.pct = 0.1,
  min.diff.pct = NULL,
  min.cells.group = 3,
  max.cells.per.cluster = NULL,
  pseudocount.use = 1,
  return.thresh = 0.01,
  only.pos = FALSE
)
}
\arguments{
\item{object}{of \code{SingleCellExperiment} class}

\item{clustering.type}{"manual" or "optimal". "manual" refers to the
clustering formed using the "SelectKClusters" function and "optimal"
to the clustering formed using the "CalcSilhInfo" function.
Default is "manual".}

\item{test}{Which test to use. Only "wilcoxon" (the Wilcoxon rank-sum test,
AKA Mann-Whitney U test) is supported at the moment.}

\item{log2fc.threshold}{Filters out genes that have log2 fold-change of the
averaged gene expression values (with the pseudo-count value added to the
averaged values before division if pseudocount.use > 0) below this threshold.
Default is \code{0.25}.}

\item{min.pct}{Filters out genes that have dropout rate (fraction of cells
expressing a gene) below this threshold in both comparison groups
Default is \code{0.1}.}

\item{min.diff.pct}{Filters out genes that do not have this minimum
difference in the dropout rates (fraction of cells expressing a gene)
between the two comparison groups. Default is \code{NULL}.}

\item{min.cells.group}{The minimum number of cells in the two comparison
groups to perform the DE analysis. If the number of cells is below the
threshold, then the DE analysis of this cluster is skipped.
Default is \code{3}.}

\item{max.cells.per.cluster}{The maximun number of cells per cluster if
downsampling is performed to speed up the DE analysis.
Default is \code{NULL}, i.e. no downsampling.}

\item{pseudocount.use}{A positive integer, which is added to
the average gene expression values before calculating the fold-change,
assuring that no divisions by zero occur. Default is \code{1}.}

\item{return.thresh}{If only.pos=TRUE, then return only genes that have the
adjusted p-value (adjusted by the Bonferroni method) below or equal to this
threshold. Default is \code{0.01}.}

\item{only.pos}{Whether to return only genes that have an adjusted p-value
(adjusted by the Bonferroni method) below or equal to the threshold.
Default is \code{FALSE}.}
}
\value{
a data frame of the results if positive results were found, else NULL
}
\description{
FindAllGeneMarkers enables identifying gene markers for all clusters at once.
This is done by differential expresission analysis where cells from one
cluster are compared against the cells from the rest of the clusters.
Gene and cell filters can be applied to accelerate
the analysis, but this might lead to missing weak signals.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(logcounts = pbmc3k_500))
sce <- PrepareILoReg(sce)
## These settings are just to accelerate the example, use the defaults.
sce <- RunParallelICP(sce,L=2,threads=1,C=0.1,k=5,r=1)
sce <- RunPCA(sce,p=5)
sce <- HierarchicalClustering(sce)
sce <- SelectKClusters(sce,K=5)
gene_markers <- FindAllGeneMarkers(sce)

}
\keyword{DE}
\keyword{analysis}
\keyword{differential}
\keyword{expression}
\keyword{gene}
\keyword{markers}
