% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_de_analyses.R
\name{get_deg_list}
\alias{get_deg_list}
\title{Get a table of differential expression expression statistics with \strong{DESeq2}}
\usage{
get_deg_list(
  se,
  coldata_column = "Generation",
  parent1 = "P1",
  parent2 = "P2",
  offspring = "F1",
  midparent = "midparent",
  lfcThreshold = 0,
  alpha = 0.01,
  ...
)
}
\arguments{
\item{se}{A \code{SummarizedExperiment} object with a count matrix and sample
metadata.}

\item{coldata_column}{Character indicating the name of column
in \code{colData(se)} where information on the generation are stored.
Default: "Generation".}

\item{parent1}{Character indicating which level of the
variable \strong{coldata_column} represents parent 1. Default: "P1".}

\item{parent2}{Character indicating which level of the
variable \strong{coldata_column} represents parent 2. Default: "P2".}

\item{offspring}{Character indicating which level of the
variable \strong{coldata_column} represents the offspring (hybrid
or allopolyploid). Default: "F1"}

\item{midparent}{Character indicating which level of the variable
\strong{coldata_column} represents the midparent value. Default:
"midparent", as returned by \code{add_midparent_expression()}.}

\item{lfcThreshold}{Numeric indicating the log2 fold-change threshold
to use to consider differentially expressed genes. Default: 0.}

\item{alpha}{Numeric indicating the adjusted P-value threshold to use
to consider differentially expressed genes. Default: 0.01.}

\item{...}{Additional arguments to be passed to \code{DESeq2::results()}.}
}
\value{
A list of data frames with DESeq2's gene-wise tests statistics
for each contrast. Each data frame contains the same columns as the
output of \code{DESeq2::results()}. Contrasts (list names) are:
\describe{
\item{P2_vs_P1}{Parent 2 (numerator) versus parent 1 (denominator).}
\item{F1_vs_P1}{Offspring (numerator) versus parent 1 (denominator).}
\item{F1_vs_P2}{Offspring (numerator) versus parent 2 (denominator).}
\item{F1_vs_midparent}{Offspring (numerator) versus midparent (denominator).}
}

The data frame with gene-wise test statistics in each list element contains
the following variables:
\describe{
\item{baseMean}{Numeric, base mean.}
\item{log2FoldChange}{Numeric, log2-transformed fold changes.}
\item{lfcSE}{Numeric, standard error of the log2-transformed fold changes.}
\item{stat}{Numeric, observed test statistic.}
\item{pvalue}{Numeric, p-value.}
\item{padj}{Numeric, P-value adjusted for multiple testing.}
}

The list contains two additional attributes named \strong{ngenes} (numeric,
total number of genes), and \strong{plotdata}, which is a 3-column data
frame with variables "gene" (character, gene ID), "lFC_F1_vs_P1" (numeric,
log2 fold change between F1 and P1), and "lFC_F1_vs_P2" (numeric,
log2 fold change between F1 and P2).
}
\description{
Get a table of differential expression expression statistics with \strong{DESeq2}
}
\examples{
data(se_chlamy)
se <- add_midparent_expression(se_chlamy)
se <- add_size_factors(se, spikein = TRUE)
deg_list <- get_deg_list(se)
}
