% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_information.R
\name{collection_information}
\alias{collection_information}
\alias{print.collection_information}
\title{Collection Information Summaries from Collection UUID}
\usage{
collection_information(uuid)

\method{print}{collection_information}(x, ...)
}
\arguments{
\item{uuid}{character(1) corresponding to the HuBMAP Collection UUID
string. This is expected to be a 32-digit hex number.}

\item{x}{an object of class \code{collection_information}, the result of a
call to \code{collection_information()}.}

\item{...}{additional arguments, required to conform with the
\code{print} generic but not used.}
}
\value{
\code{collection_information()} returns a tibble,
and columns containing information about the collection. The
tibble is of class \code{collection_information} and is printed in character.

\code{print.collection_information()} is invoked automatically when
the result of \code{collection_information()} is displayed for it's
side effect of displaying the object.
}
\description{
\code{collection_information()} queries the HuBMAP collection for
title, description, DOI, URL, creation date, and last modified time date.

\code{print.collection_information()} organizes the returned tibble
from \code{collection_information()} in a more legible format.
}
\examples{
uuid <- "90399057f6ff0ff18d4c46a378f0b069"
collection_information(uuid)

}
