% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotAPA.r
\name{preparePlotgardener}
\alias{preparePlotgardener}
\title{preparePlotgardener}
\usage{
preparePlotgardener(
  hicList = NULL,
  ctrlHicList = NULL,
  submatrices = NULL,
  submatrix.name = NULL,
  diffFun = "log2ratio",
  which_chrom = NULL,
  which_range = NULL
)
}
\arguments{
\item{hicList}{hicList from which to extract data}

\item{ctrlHicList}{hicList to use as control
for a differential analysis.}

\item{submatrices}{list of submatrices.}

\item{submatrix.name}{name of submatrix
to focus on. use \code{names(submatrices)}. If submatrices is not \code{NULL},
this argument must not be \code{NULL}.}

\item{diffFun}{The function used
to compute differential between counts column of hicList and ctrlHicList.
If the argument is a character, possible choices are:
\itemize{
\item "-", "substract" or "substraction" apply a substraction (Default)
\item "/" or "ratio" apply a ratio
\item "log2","log2-","log2/" or "log2ratio" apply a log2 on ratio
\item other apply a log2 on 1+ratio
}}

\item{which_chrom}{a combination
of chromsome names use \code{names(hicList)} to see the possible names.}

\item{which_range}{a GRanges object
or a string of type "chr1:1-100". see \code{StrToGranges()}.}
}
\value{
funcions returns a data.frame with 3 columns:
chrom, altchrom and counts. chrom being bin names of rows, altchrom being
bin names of columns and counts being the counts.
see also \code{strawr::straw()} & plotgardener::readHic()
}
\description{
This function allows to obtain a dataframe that can be
used with plotgardener's plotHicTriangle, plotHicRectangle,
plotHicSquare. It is equivalent to plotgardener's readHic function.
}
\examples{
data(HiC_Ctrl.cmx_lst)
data(HiC_HS.cmx_lst)
preparePlotgardener(
  hicList = HiC_HS.cmx_lst,
  ctrlHicList = HiC_Ctrl.cmx_lst,
  which_chrom = "2L_2L",
  diffFun = "substract")|> head()
  
}
